#ifdef _DEBUG
#include <stdio.h>
#endif

#include <windows.h>
#include "resource.h"
#include "Gfx #1.3.h"
#include "rdp.h"
#include "vi.h"

BOOL CALLBACK ConfigDlgProc(HWND hDlg, UINT uMsg, WPARAM wParam, LPARAM lParam);
HWND sWidth, sHeight;
HINSTANCE hinst;

unsigned char cfg[32] = {
    0x02, 0x7F, /* custom digital screen width, minus one */
    0x01, 0xDF, /* custom digital screen height, minus one */

/*
 * screen resolution formula methods
 * 0x00:  VI DAC to NTSC/PAL
 * 0x01:  DP frame buffer active video
 * 0x02:  user-defined (cares what the above two words are)
 */
    0x00,

/*
 * reserved for future use as a graphics microcode simulation setting
 * 0xFF:  no microcode simulation (force LLE graphics)
 * 0x00:  automatic (if asked to do HLE, try to auto-detect microcode)
 * 0x01:  RSP SW
 * 0x02:  F3DEX
 * ...
 */
    0x00,

/*
 * reserved for doing extra OpenGL stuff...brightness, extra filtering?
 * not yet implemented
 */
    0x00, 0x00,
    0x00, 0x00,
    0x00, 0x00,
    0x00, 0x00,

    0x00, /* Skip UpdateScreen this many times. */
    0x00, /* Skip ProcessDList (and ProcessRDPList) this many times. */

/*
 * 64-bit Boolean flags, bits 63..48 (little-endian):
 * currently reserved
 */
    0x00, 0x00,

/*
 * 64-bit Boolean flags, bits 47..32:
 * currently reserved
 */
    0x00, 0x00,

/*
 * 64-bit Boolean flags, bits 31..16:
 * currently reserved
 */
    0x00, 0x00,

/*
 * 64-bit Boolean flags, bits 15..0:
 *  0.  Ignore and bypass all VI_STATUS_REG filter modes?
 *  1.  Emulate alternative TV size (calculated with bi-linear scaling)?
 *  2.  Pause emulation after every screen update?
 */
    0x00, 0x00,

/*
 * spare bytes for other types of configuration?
 * currently unused
 */
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00
};

BOOL WINAPI DllMain(HINSTANCE hinstDLL, /* DLL module handle */
	DWORD fdwReason,                    /* reason called */
	LPVOID lpvReserved)                 /* reserved */
{
	hinst = hinstDLL;
	return TRUE;
}

EXPORT void CALL DllAbout(HWND hParent)
{
    MessageBox(
        hParent,

        "angrylion's pixel-accurate RDP from MESS code\n"\
        "Thanks to RPGMaster for the Win32 GUI and config.",

        "Iconoclast's OpenGL",
        MB_ICONINFORMATION);
    return;
}

EXPORT void CALL DllConfig(HWND hParent)
{
#ifdef _DEBUG
    char text_buf[192];

    trace_VI_registers();
    sprintf(
        text_buf,

        "CYCLE_TYPE_1   :  %d\n"\
        "CYCLE_TYPE_2   :  %d\n"\
        "CYCLE_TYPE_COPY:  %d\n"\
        "CYCLE_TYPE_FILL:  %d",

        render_cycle_mode_counts[CYCLE_TYPE_1],
        render_cycle_mode_counts[CYCLE_TYPE_2],
        render_cycle_mode_counts[CYCLE_TYPE_COPY],
        render_cycle_mode_counts[CYCLE_TYPE_FILL]);
    MessageBox(hParent, text_buf, "Render Spans Cycle Mode Counts", MB_OK);
#endif
    if (emulation_running == FALSE)
    {
#if 0
        DisplayError("Tried to access config without emulation thread.");
#else
        int pass;

        pass = file_in("RDP_CONF.BIN", cfg, 32);
        if (pass == 0)
            DisplayError("Could not open `RDP_CONF.BIN'.");
        DialogBox(hinst, (LPCSTR)IDD_DIALOG1, hParent, ConfigDlgProc);
        file_out("RDP_CONF.BIN", cfg, 32);
#endif
    }
    else
        DialogBox(hinst, (LPCSTR)IDD_DIALOG1, hParent, ConfigDlgProc);
    sync = TRUE;
#ifdef TRACE_DP_COMMANDS
    count_DP_commands();
#endif
    return;
}

BOOL CALLBACK ConfigDlgProc(
    HWND hDlg, UINT Message, WPARAM wParam, LPARAM lParam)
{
    HWND item;
    LRESULT response;
    unsigned int value;

    switch (Message)
    {
        case WM_INITDIALOG:
            SendDlgItemMessage(
                hDlg, VI_STATUS_REG_FILTER, BM_SETCHECK, cfg[23]>>0 & 1, 0);
            SendDlgItemMessage(
                hDlg, GPU_ACCELERATED_SCALING, BM_SETCHECK, cfg[23]>>1 & 1, 0);
            SendDlgItemMessage(
                hDlg, PAUSE_EVERY_FRAME, BM_SETCHECK, cfg[23]>>2 & 1, 0);
            if (cfg[4] == 0x00)
                SendDlgItemMessage(hDlg, VI_REGISTER_LAYOUT, BM_SETCHECK, 1, 0);
            else if (cfg[4] == 0x01)
                SendDlgItemMessage(hDlg, DP_FRAME_BUFFER, BM_SETCHECK, 1, 0);
            else if (cfg[4] == 0x02)
                SendDlgItemMessage(hDlg, USER_DEFINED, BM_SETCHECK, 1, 0);

/*
 * i store the HWND of the width and height textboxes to prevent having to
 * call GetDlgItem() multiple times
 */
            EnableWindow(
                sWidth  = GetDlgItem(hDlg, SCREEN_WIDTH),  cfg[4] == 2);
            EnableWindow(
                sHeight = GetDlgItem(hDlg, SCREEN_HEIGHT), cfg[4] == 2);
            SetDlgItemInt(hDlg, UPDATE_SCREEN, cfg[14], 0);
            SetDlgItemInt(hDlg, PROCESSDLIST,  cfg[15], 0);
            value = ((cfg[0] << 8) | cfg[1]) + 1;
            SetDlgItemInt(hDlg, SCREEN_WIDTH,  value, 0);
            value = ((cfg[2] << 8) | cfg[3]) + 1;
            SetDlgItemInt(hDlg, SCREEN_HEIGHT, value, 0);

            item = GetDlgItem(hDlg, MICROCODE);
            SendMessage(item, CB_ADDSTRING, 0, (LPARAM)" 0:  Automatic");
            SendMessage(item, CB_ADDSTRING, 0, (LPARAM)" 1:  RSP SW");
            SendMessage(item, CB_ADDSTRING, 0, (LPARAM)" 2:  F3DEX");

/*
 * sets selection to automatic
 */
            SendMessage(item, CB_SETCURSEL, 0, 0);
            break;
        case WM_COMMAND:
            switch (LOWORD(wParam))
            {
                case IDOK:
                case IDAPPLY:
                    value = GetDlgItemInt(hDlg, SCREEN_WIDTH, 0, 0) - 1;
                    cfg[0] = value >> 8;
                    cfg[1] = value;
                    value = GetDlgItemInt(hDlg, SCREEN_HEIGHT, 0, 0) - 1;
                    cfg[2] = value >> 8;
                    cfg[3] = value;

                    cfg[23] &= ~(0x01 << 0);
                    cfg[23] &= ~(0x01 << 1);
                    cfg[23] &= ~(0x01 << 2);
                    response = SendDlgItemMessage(
                        hDlg, VI_STATUS_REG_FILTER, BM_GETCHECK, 0, 0);
                    cfg[23] |= (response == TRUE) << 0;
                    response = SendDlgItemMessage(
                        hDlg, GPU_ACCELERATED_SCALING, BM_GETCHECK, 0, 0);
                    cfg[23] |= (response == TRUE) << 1;
                    response = SendDlgItemMessage(
                        hDlg, PAUSE_EVERY_FRAME, BM_GETCHECK, 0, 0);
                    cfg[23] |= (response == TRUE) << 2;

                    response = SendDlgItemMessage(
                        hDlg, VI_REGISTER_LAYOUT, BM_GETCHECK, 0, 0);
                    if (response == TRUE)
                        cfg[4] = 0;
                    else
                    {
                        response = SendDlgItemMessage(
                            hDlg, DP_FRAME_BUFFER, BM_GETCHECK, 0, 0);
                        if (response == TRUE)
                            cfg[4] = 0x01;
                        else
                        {
                            response = SendDlgItemMessage(
                                hDlg, USER_DEFINED, BM_GETCHECK, 0, 0);
                            if (response == TRUE)
                                cfg[4] = 0x02;
                        }
                    }
                    cfg[14] = GetDlgItemInt(hDlg, UPDATE_SCREEN, 0, 0);
                    cfg[15] = GetDlgItemInt(hDlg, PROCESSDLIST, 0, 0);
                    if (LOWORD(wParam) != IDAPPLY)
                    {
                        case IDCANCEL:
                            EndDialog(hDlg, TRUE);
                    }
                    break;
                case VI_REGISTER_LAYOUT:
                case DP_FRAME_BUFFER:
                    EnableWindow(sWidth,  FALSE); /* disables width textbox */
                    EnableWindow(sHeight, FALSE); /* disables height textbox */
                    break;

                case USER_DEFINED:
                    EnableWindow(sWidth,  TRUE); /* enables width textbox */
                    EnableWindow(sHeight, TRUE); /* enables height textbox */
                    break;
            }
            break;
        default:
        return FALSE;
    }
    return TRUE;
}

static char results[] = {
    "nSize\n\t0000\n"\
    "nVersion\n\t0000\n"\
    "dwFlags\n\t00000000\n"\
    "iPixelType\n\t00\n"\
    "cColorBits\n\t00\n"\
    "cRedBits\n\t00\n"\
    "cRedShift\n\t00\n"\
    "cGreenBits\n\t00\n"\
    "cGreenShift\n\t00\n"\
    "cBlueBits\n\t00\n"\
    "cBlueShift\n\t00\n"\
    "cAlphaBits\n\t00\n"\
    "cAlphaShift\n\t00\n"\
    "cAccumBits\n\t00\n"\
    "cAccumRedBits\n\t00\n"\
    "cAccumGreenBits\n\t00\n"\
    "cAccumBlueBits\n\t00\n"\
    "cAccumAlphaBits\n\t00\n"\
    "cDepthBits\n\t00\n"\
    "cStencilBits\n\t00\n"\
    "cAuxBuffers\n\t00\n"\
    "iLayerType\n\t00\n"\
    "bReserved\n\t00\n"\
    "dwLayerMask\n\t00000000\n"\
    "dwVisibleMask\n\t00000000\n"\
    "dwDamageMask\n\t00000000\n"\
};
static const char digits[16] = {
    '0','1','2','3','4','5','6','7','8','9','A','B','C','D','E','F'
};
EXPORT void CALL DllTest(HWND hParent)
{
    PIXELFORMATDESCRIPTOR test;
    int pixel_format_enum;
    int formats;

    if (device_context == NULL)
    {
        DisplayError(
            "No current device context.\n"\
            "Try initializing the plugin before testing it."
        );
        return;
    }

    MessageBox(hParent, "Begin testing.", "DllTest", MB_ICONINFORMATION);
    pixel_format_enum = GetPixelFormat(device_context);
    formats = ChoosePixelFormat(device_context, &pixel_format);
    if (pixel_format_enum != formats)
        DisplayWarning("Mismatch between run-time and test pixel formats.");
    if (pixel_format_enum == 0)
    {
        DisplayError("No suitable pixel format detected on this system.");
        return;
    }

    formats = DescribePixelFormat(
        device_context,
        pixel_format_enum,
        sizeof(PIXELFORMATDESCRIPTOR),
        &test);
    if (formats == 0)
    {
        DisplayError("No suitable pixel format detected on this system.");
        return;
    }

    results[  7] = digits[(test.nSize & 0xF000) >> 12];
    results[  8] = digits[(test.nSize & 0x0F00) >>  8];
    results[  9] = digits[(test.nSize & 0x00F0) >>  4];
    results[ 10] = digits[(test.nSize & 0x000F) >>  0];

    results[ 22] = digits[(test.nVersion & 0xF000) >> 12];
    results[ 23] = digits[(test.nVersion & 0x0F00) >>  8];
    results[ 24] = digits[(test.nVersion & 0x00F0) >>  4];
    results[ 25] = digits[(test.nVersion & 0x000F) >>  0];

    results[ 36] = digits[(test.dwFlags & 0xF0000000) >> 28];
    results[ 37] = digits[(test.dwFlags & 0x0F000000) >> 24];
    results[ 38] = digits[(test.dwFlags & 0x00F00000) >> 20];
    results[ 39] = digits[(test.dwFlags & 0x000F0000) >> 16];
    results[ 40] = digits[(test.dwFlags & 0x0000F000) >> 12];
    results[ 41] = digits[(test.dwFlags & 0x00000F00) >>  8];
    results[ 42] = digits[(test.dwFlags & 0x000000F0) >>  4];
    results[ 43] = digits[(test.dwFlags & 0x0000000F) >>  0];

    results[ 57] = digits[(test.iPixelType & 0xF0) >> 4];
    results[ 58] = digits[(test.iPixelType & 0x0F) >> 0];
    results[ 72] = digits[(test.cColorBits & 0xF0) >> 4];
    results[ 73] = digits[(test.cColorBits & 0x0F) >> 0];
    results[ 85] = digits[(test.cRedBits & 0xF0) >> 4];
    results[ 86] = digits[(test.cRedBits & 0x0F) >> 0];
    results[ 99] = digits[(test.cRedShift & 0xF0) >> 4];
    results[100] = digits[(test.cRedShift & 0x0F) >> 0];
    results[114] = digits[(test.cGreenBits & 0xF0) >> 4];
    results[115] = digits[(test.cGreenBits & 0x0F) >> 0];
    results[130] = digits[(test.cGreenShift & 0xF0) >> 4];
    results[131] = digits[(test.cGreenShift & 0x0F) >> 0];
    results[144] = digits[(test.cBlueBits & 0xF0) >> 4];
    results[145] = digits[(test.cBlueBits & 0x0F) >> 0];
    results[159] = digits[(test.cBlueShift & 0xF0) >> 4];
    results[160] = digits[(test.cBlueShift & 0x0F) >> 0];
    results[174] = digits[(test.cAlphaBits & 0xF0) >> 4];
    results[175] = digits[(test.cAlphaBits & 0x0F) >> 0];
    results[190] = digits[(test.cAlphaShift & 0xF0) >> 4];
    results[191] = digits[(test.cAlphaShift & 0x0F) >> 0];
    results[205] = digits[(test.cAccumBits & 0xF0) >> 4];
    results[206] = digits[(test.cAccumBits & 0x0F) >> 0];
    results[223] = digits[(test.cAccumRedBits & 0xF0) >> 4];
    results[224] = digits[(test.cAccumRedBits & 0x0F) >> 0];
    results[243] = digits[(test.cAccumGreenBits & 0xF0) >> 4];
    results[244] = digits[(test.cAccumGreenBits & 0x0F) >> 0];
    results[262] = digits[(test.cAccumBlueBits & 0xF0) >> 4];
    results[263] = digits[(test.cAccumBlueBits & 0x0F) >> 0];
    results[282] = digits[(test.cAccumAlphaBits & 0xF0) >> 4];
    results[283] = digits[(test.cAccumAlphaBits & 0x0F) >> 0];
    results[297] = digits[(test.cDepthBits & 0xF0) >> 4];
    results[298] = digits[(test.cDepthBits & 0x0F) >> 0];
    results[314] = digits[(test.cStencilBits & 0xF0) >> 4];
    results[315] = digits[(test.cStencilBits & 0x0F) >> 0];
    results[330] = digits[(test.cAuxBuffers & 0xF0) >> 4];
    results[331] = digits[(test.cAuxBuffers & 0x0F) >> 0];
    results[345] = digits[(test.iLayerType & 0xF0) >> 4];
    results[346] = digits[(test.iLayerType & 0x0F) >> 0];
    results[359] = digits[(test.bReserved & 0xF0) >> 4];
    results[360] = digits[(test.bReserved & 0x0F) >> 0];

    results[375] = digits[(test.dwLayerMask & 0xF0000000) >> 28];
    results[376] = digits[(test.dwLayerMask & 0x0F000000) >> 24];
    results[377] = digits[(test.dwLayerMask & 0x00F00000) >> 20];
    results[378] = digits[(test.dwLayerMask & 0x000F0000) >> 16];
    results[379] = digits[(test.dwLayerMask & 0x0000F000) >> 12];
    results[380] = digits[(test.dwLayerMask & 0x00000F00) >>  8];
    results[381] = digits[(test.dwLayerMask & 0x000000F0) >>  4];
    results[382] = digits[(test.dwLayerMask & 0x0000000F) >>  0];

    results[399] = digits[(test.dwVisibleMask & 0xF0000000) >> 28];
    results[400] = digits[(test.dwVisibleMask & 0x0F000000) >> 24];
    results[401] = digits[(test.dwVisibleMask & 0x00F00000) >> 20];
    results[402] = digits[(test.dwVisibleMask & 0x000F0000) >> 16];
    results[403] = digits[(test.dwVisibleMask & 0x0000F000) >> 12];
    results[404] = digits[(test.dwVisibleMask & 0x00000F00) >>  8];
    results[405] = digits[(test.dwVisibleMask & 0x000000F0) >>  4];
    results[406] = digits[(test.dwVisibleMask & 0x0000000F) >>  0];

    results[422] = digits[(test.dwDamageMask & 0xF0000000) >> 28];
    results[423] = digits[(test.dwDamageMask & 0x0F000000) >> 24];
    results[424] = digits[(test.dwDamageMask & 0x00F00000) >> 20];
    results[425] = digits[(test.dwDamageMask & 0x000F0000) >> 16];
    results[426] = digits[(test.dwDamageMask & 0x0000F000) >> 12];
    results[427] = digits[(test.dwDamageMask & 0x00000F00) >>  8];
    results[428] = digits[(test.dwDamageMask & 0x000000F0) >>  4];
    results[429] = digits[(test.dwDamageMask & 0x0000000F) >>  0];

    file_out("gl_pfd.txt", results, sizeof(results));
    MessageBox(
        hParent,
        "Finished PFD tests.\nCheck `gl_pfd.txt'.",
        "DllTest",
        MB_ICONINFORMATION);
    return;
}
